/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.toolkit.utils.table.IVWSortItem;

public class VWParticipantItem
implements IVWSortItem {
    public static final int ITEM_USER = 0;
    public static final int ITEM_GROUP = 1;
    public static final int ITEM_WORKFLOWGROUP = 2;
    public static final int ITEM_ALL = 3;
    public static final int ITEM_UNKNOWN = 4;
    protected String m_shortName = null;
    protected int m_itemType = 4;
    protected VWParticipant m_vwParticipant = null;

    public VWParticipantItem(String shortName, int nType) throws VWException {
        this.m_shortName = shortName;
        this.m_itemType = nType;
        switch (this.m_itemType) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new VWException("vw.toolkit.utils.table.InvalidType", "Invalid type.");
            }
        }
    }

    public VWParticipantItem(VWParticipant vwParticipant) {
        this.m_vwParticipant = vwParticipant;
        if (this.m_vwParticipant != null) {
            this.m_shortName = this.m_vwParticipant.getParticipantName();
            if (this.m_shortName != null && this.m_vwParticipant.isVerified()) {
                this.m_itemType = this.m_vwParticipant.isGroup() ? 1 : 0;
            }
        }
    }

    public String getDisplayName() {
        String displayName;
        if (this.m_vwParticipant != null && (displayName = this.m_vwParticipant.getDisplayName()) != null && displayName.length() > 0) {
            return displayName;
        }
        return this.getShortName();
    }

    public String getShortName() {
        return this.m_shortName;
    }

    public int getType() {
        return this.m_itemType;
    }

    public VWParticipant getVWParticipant() {
        return this.m_vwParticipant;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void releaseResources() {
        this.m_shortName = null;
        this.m_vwParticipant = null;
    }

    public String getName() {
        return this.getDisplayName();
    }
}

